﻿using System;
using System.Linq;
using System.Web;
using System.Web.UI.WebControls;
using VIRP_WEB.BaseCode;

namespace VIRP_WEB.Controls.Custom.BPR
{
    public partial class controls_BaseControlDropDownList : System.Web.UI.UserControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }
        public string Text
        {
            get
            {
                return HiddenFieldID.Value;
            }
            set
            {
                DropDownListID.SelectedIndex = -1;
                HiddenFieldID.Value = value;
                foreach (ListItem item in DropDownListID.Items)
                {
                    if (item.Value == value.Trim())
                    {
                        item.Selected = true;
                        break;
                    }
                }
            }
        }

        public string DescriptionText
        {
            get
            {
                string description = string.Empty;
                if (!string.IsNullOrEmpty(HiddenFieldID.Value))
                {
                    foreach (ListItem item in DropDownListID.Items)
                    {
                        if (item.Value == HiddenFieldID.Value.Trim())
                        {
                            description = item.Text;
                            break;
                        }
                    }
                }
                return description;
            }
        }

        public void SetValueAsText()
        {
            foreach (ListItem radioListItem in DropDownListID.Items)
            {
                radioListItem.Value = radioListItem.Text;
            }
        }

        public void RemoveEmptyItem()
        {
            foreach (ListItem item in DropDownListID.Items)
            {
                if (string.IsNullOrEmpty(item.Value) && string.IsNullOrEmpty(item.Text))
                {
                    DropDownListID.Items.Remove(item);
                    break;
                }
            }
        }

        public string LabelText
        {
            get
            {
                return LabelforLabelID.Text;
            }
            set
            {
                LabelforLabelID.Text = value;
            }
        }


        public string Tooltip
        {
            get
            {
                return DropDownListID.ToolTip;
            }
            set
            {
                LabelforLabelID.ToolTip = value;
                DropDownListID.ToolTip = value;
            }
        }

        public bool IncludeLabel
        {
            set
            {
                LabelforLabelID.Visible = value;
            }
        }

        public string LookUpCategory
        {
            set
            {
                if (!string.IsNullOrEmpty(value) && DropDownListID.Items.Count == 1)
                {
                    ServiceInterfaceManager manager = new ServiceInterfaceManager();
                    var lookupList = manager.SelectLookupList(value);
                    
                    if (value == "MY_TEMPLATES_TITLE")
                    {
                        lookupList = (from e in lookupList
                                      where e.CODE == HttpContext.Current.User.Identity.Name
                                      select e).ToList();
                    }

                    //decode dropdown list for send message
                    foreach (SoaServices.VIEW_LOOKUP item in lookupList)
                    { 
                        item.NAME = Server.HtmlDecode(item.NAME);
                    }
                    DropDownListID.DataSource = lookupList;

                    if (value == "DEPLOYMENT_COUNTRY" || value == "DEPLOYMENT_COUNTRY_EXPOSURE" || value == "STD_GENDER" ||
                        value == "STD_ELIGIBLITYSTATUS" || value == "STD_RACE" || value == "STD_ETHNICITY" || value == "CONTACT_PREFERENCE" || value == "ENROLLMENT_STATUS")
                    {
                        DropDownListID.DataValueField = "NAME";
                    }
                    else
                    {
                        DropDownListID.DataValueField = "ID";
                    }
                    DropDownListID.DataTextField = "NAME";
                    DropDownListID.DataBind();
                    AddAttributes();
                }
            }
        }

        /// <summary>
        /// Set Required validator
        /// </summary>
        public bool IsRequired
        {
            set
            {
                if (value)
                {
                    RequiredFieldValidatorID.Visible = true;
                    RequiredFieldValidatorID.Enabled = true;
                }
                else
                {
                    RequiredFieldValidatorID.Visible = false;
                    RequiredFieldValidatorID.Enabled = false;
                }
            }
        }

        /// <summary>
        /// Set the validationErrorMessage
        /// </summary>
        public string ValidationErrorMessage
        {
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    RequiredFieldValidatorID.ErrorMessage = value;
                    RequiredFieldValidatorID.Visible = true;
                    RequiredFieldValidatorID.Enabled = true;
                }
            }
        }
        /// <summary>
        /// Set validation group
        /// </summary>
        public string ValidationGroup
        {
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    RequiredFieldValidatorID.ValidationGroup = value;
                    RequiredFieldValidatorID.Visible = true;
                    RequiredFieldValidatorID.Enabled = true;
                }
            }
        }

        public void LoadControlsFromObject(string text, string labelText, string tooltip, bool includeLabel, string lookupCategory,
                                           string validationGroup, string validationErrorMsg, bool isRequired)
        {
            if (!string.IsNullOrEmpty(tooltip))
            {
                Tooltip = tooltip;
            }
            if (!string.IsNullOrEmpty(text))
            {
                Text = text;
            }
            if (!string.IsNullOrEmpty(labelText))
            {
                LabelText = labelText;
            }

            IncludeLabel = includeLabel;
            LookUpCategory = lookupCategory;
            ValidationGroup = validationGroup;
            ValidationErrorMessage = validationErrorMsg;
            IsRequired = isRequired;
        }

        private void AddAttributes()
        {
            if (DropDownListID.Attributes["onchange"] == null)
            {
                DropDownListID.Attributes.Add("onchange",
                    "SetBaseControlTextValue(this, '" + HiddenFieldID.ClientID + "')");
            }
        }
    }
}